(function ($) {
    "use strict";
    
    // Dropdown on mouse hover
    $(document).ready(function () {
        function toggleNavbarMethod() {
            if ($(window).width() > 992) {
                $('.navbar .dropdown').on('mouseover', function () {
                    $('.dropdown-toggle', this).trigger('click');
                }).on('mouseout', function () {
                    $('.dropdown-toggle', this).trigger('click').blur();
                });
            } else {
                $('.navbar .dropdown').off('mouseover').off('mouseout');
            }
        }
        toggleNavbarMethod();
        $(window).resize(toggleNavbarMethod);
    });
    
    
    // Back to top button
    $(window).scroll(function () {
        if ($(this).scrollTop() > 100) {
            $('.back-to-top').fadeIn('slow');
        } else {
            $('.back-to-top').fadeOut('slow');
        }
    });
    $('.back-to-top').click(function () {
        $('html, body').animate({scrollTop: 0}, 1500, 'easeInOutExpo');
        return false;
    });
    

    // Date and time picker
    $('.date').datetimepicker({
        format: 'L'
    });
    $('.time').datetimepicker({
        format: 'LT'
    });


    // Testimonials carousel
    $(".testimonial-carousel").owlCarousel({
        autoplay: true,
        smartSpeed: 1500,
        margin: 30,
        dots: true,
        loop: true,
        center: true,
        responsive: {
            0:{
                items:1
            },
            576:{
                items:1
            },
            768:{
                items:2
            },
            992:{
                items:3
            }
        }
    });
    
})(jQuery);

 const header = document.getElementById("smart-header");
  let lastScrollTop = 0;

  window.addEventListener("scroll", function () {
    const currentScroll = window.pageYOffset || document.documentElement.scrollTop;

    // Show/hide header on scroll direction
    if (currentScroll > lastScrollTop) {
      header.style.top = "-118px"; // Scrolling down: hide
    } else {
      header.style.top = "0"; // Scrolling up: show
    }

    // Change background based on scroll position
    if (currentScroll <= 0) {
    //   header.classList.remove("scrolled"); 
      // Transparent at top
    } else {
      header.classList.add("scrolled"); // Solid on scroll
    }

    lastScrollTop = currentScroll <= 0 ? 0 : currentScroll;
  });


document.addEventListener("DOMContentLoaded", function () {
    const OFFSET = 80; // Adjust based on header height
    const navLinks = document.querySelectorAll(".navbar-nav .nav-link");
    const navbarCollapse = document.querySelector(".navbar-collapse");

    navLinks.forEach(link => {
      link.addEventListener("click", function (e) {
        const hash = this.getAttribute("href");

        // Handle smooth scroll if href starts with #
        if (hash.startsWith("#")) {
          e.preventDefault();
          const target = document.querySelector(hash);
          if (target) {
            const targetPosition = target.offsetTop - OFFSET;
            window.scrollTo({
              top: targetPosition,
              behavior: "smooth"
            });
          }
        }

        // Collapse navbar if open
        if (navbarCollapse.classList.contains("show")) {
          new bootstrap.Collapse(navbarCollapse).hide();
        }

        // Handle active class
        navLinks.forEach(nav => nav.classList.remove("active"));
        this.classList.add("active");
      });
    });
  });
  



const banner = document.getElementById('blog-carousel');
    const fadeStart = 50;  // scroll Y position at which fade starts
    const fadeUntil = 800; // scroll Y at which it becomes fully faded (or minimal)

    window.addEventListener('scroll', () => {
      const scrollY = window.scrollY || window.pageYOffset;

      if (scrollY <= fadeStart) {
        banner.style.opacity = '1';
      } else if (scrollY >= fadeUntil) {
        banner.style.opacity = '0';
      } else {
        const fraction = (scrollY - fadeStart) / (fadeUntil - fadeStart);
        // invert fraction for fading: 0 → 1 maps to 1 → 0
        const newOpacity = 1 - fraction;
        banner.style.opacity = String(newOpacity);
      }
    });
